/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import technology.rocketjump.undermount.input.GameWorldInputHandler;
import technology.rocketjump.undermount.ui.fonts.FontRepository;
import technology.rocketjump.undermount.ui.fonts.GameFont;
import technology.rocketjump.undermount.ui.i18n.I18nTranslator;
import technology.rocketjump.undermount.ui.skins.GuiSkinRepository;

public class IntroScreen
implements Screen {
    private final MessageDispatcher messageDispatcher;
    private final I18nTranslator i18nTranslator;
    private final GameFont font;
    private final Stage stage;
    private final OrthographicCamera camera = new OrthographicCamera();
    private List<List<Label>> introTextGroups = new ArrayList<List<Label>>();
    private Table containerTable;
    private Table innerTable;
    private static final float FADE_IN_TIME = 1.5f;
    private static final float TIME_PER_GROUP = 3.0f;
    private float timeElapsedThisGroup;
    private int groupCursor = 0;

    @Inject
    public IntroScreen(FontRepository fontRepository, GuiSkinRepository guiSkinRepository, MessageDispatcher messageDispatcher, I18nTranslator i18nTranslator) {
        this.font = fontRepository.getLargestFont();
        this.messageDispatcher = messageDispatcher;
        this.i18nTranslator = i18nTranslator;
        Skin uiSkin = guiSkinRepository.getDefault();
        this.containerTable = new Table(uiSkin);
        this.containerTable.setFillParent(true);
        this.containerTable.center();
        this.innerTable = new Table(uiSkin);
        this.innerTable.setFillParent(false);
        this.innerTable.center();
        this.stage = new Stage();
        this.stage.addActor(this.containerTable);
    }

    private Label buildLabel(String text) {
        Label.LabelStyle labelStyle = new Label.LabelStyle(this.font.getBitmapFont(), Color.WHITE);
        Label label = new Label((CharSequence)text, labelStyle);
        label.setColor(0.0f, 0.0f, 0.0f, 0.0f);
        return label;
    }

    private void resetTable() {
        this.stage.clear();
        this.containerTable.clearChildren();
        this.innerTable.clearChildren();
        this.resetTextGroups();
        for (List<Label> introTextGroup : this.introTextGroups) {
            for (Label label : introTextGroup) {
                label.setColor(0.0f, 0.0f, 0.0f, 0.0f);
                this.innerTable.add(label).center();
                this.innerTable.row();
            }
            this.innerTable.add(new Table()).pad(20.0f);
            this.innerTable.row();
        }
        this.containerTable.add(this.innerTable).center();
        this.stage.addActor(this.containerTable);
    }

    private void resetTextGroups() {
        this.introTextGroups.clear();
        this.introTextGroups.add(Arrays.asList(this.buildLabel(this.i18nTranslator.getTranslatedString("INTRO.LINE.1A")), this.buildLabel(this.i18nTranslator.getTranslatedString("INTRO.LINE.1B"))));
        this.introTextGroups.add(Arrays.asList(this.buildLabel(this.i18nTranslator.getTranslatedString("INTRO.LINE.2A")), this.buildLabel(this.i18nTranslator.getTranslatedString("INTRO.LINE.2B"))));
        this.introTextGroups.add(Arrays.asList(this.buildLabel(this.i18nTranslator.getTranslatedString("INTRO.LINE.3A")), this.buildLabel(this.i18nTranslator.getTranslatedString("INTRO.LINE.3B"))));
        this.introTextGroups.add(Arrays.asList(this.buildLabel(this.i18nTranslator.getTranslatedString("INTRO.LINE.4"))));
    }

    @Override
    public void show() {
        Gdx.input.setInputProcessor(this.stage);
        this.groupCursor = 0;
        this.timeElapsedThisGroup = 0.0f;
        this.resize(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        Gdx.input.setInputProcessor(new IntroInputHandler(this.messageDispatcher));
    }

    @Override
    public void hide() {
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.timeElapsedThisGroup += delta;
        if (this.timeElapsedThisGroup > 3.0f) {
            this.timeElapsedThisGroup = 0.0f;
            ++this.groupCursor;
        }
        if (this.groupCursor >= this.introTextGroups.size()) {
            this.messageDispatcher.dispatchMessage(1);
        } else {
            List<Label> group = this.introTextGroups.get(this.groupCursor);
            float alpha = this.timeElapsedThisGroup / 1.5f;
            if (alpha > 1.0f) {
                alpha = 1.0f;
            }
            for (Label label : group) {
                label.setColor(1.0f, 1.0f, 1.0f, alpha);
            }
        }
        this.camera.update();
        this.stage.act();
        this.stage.draw();
    }

    @Override
    public void resize(int width, int height) {
        this.camera.setToOrtho(false, width, height);
        this.stage.setViewport(new ScreenViewport(new OrthographicCamera(width, height)));
        this.stage.getViewport().update(width, height, true);
        this.resetTable();
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void dispose() {
    }

    private static class IntroInputHandler
    implements InputProcessor {
        private final MessageDispatcher messageDispatcher;

        private IntroInputHandler(MessageDispatcher messageDispatcher) {
            this.messageDispatcher = messageDispatcher;
        }

        @Override
        public boolean keyDown(int keycode) {
            return false;
        }

        @Override
        public boolean keyUp(int keycode) {
            if (keycode == 131 || keycode == 66) {
                this.messageDispatcher.dispatchMessage(1);
            } else if (keycode == 254) {
                GameWorldInputHandler.toggleFullscreen();
            } else {
                return false;
            }
            return true;
        }

        @Override
        public boolean keyTyped(char character) {
            return false;
        }

        @Override
        public boolean touchDown(int screenX, int screenY, int pointer, int button) {
            return false;
        }

        @Override
        public boolean touchUp(int screenX, int screenY, int pointer, int button) {
            return false;
        }

        @Override
        public boolean touchDragged(int screenX, int screenY, int pointer) {
            return false;
        }

        @Override
        public boolean mouseMoved(int screenX, int screenY) {
            return false;
        }

        @Override
        public boolean scrolled(int amount) {
            return false;
        }
    }
}

